//Caption: Performing Linear Convolution using Circular Convolution

clear;
clc;
close;
h = [1,2,3];    //Impulse Response of LTI System
x = [1,2,2,1];  //Input Response of LTI System
N1 = length(x);
N2 = length(h);
N = N1+N2-1
disp(N,'Length of Output Response y(n)')
//Padding zeros to Make Length of 'h' and 'x'
//Equal to length of output response 'y'
h1 = [h,zeros(1,N-N2)];
x1 = [x,zeros(1,N-N1)];
//Computing FFT 
H = fft(h1,-1);
X = fft(x1,-1);
//Multiplication of 2 DFTs
Y = X.*H
//Linear Convolution Result
y =abs(fft(Y,1))
disp(X,'DFT of i/p X(k)=')
disp(H,'DFT of impulse sequence H(k)=')
disp(Y,'DFT of Linear Filter o/p Y(k)=')
disp(y,'Linear Convolution result y[n]=')
//Result
// Length of Output Response y(n)   
// 
//    6.  
// 
// DFT of i/p X(k)=   
// 
//    6.  - 3.4641016i    0    0    0    3.4641016i  
// 
// DFT of impulse sequence H(k)=   
// 
//    6.    0.5 - 4.330127i  - 1.5 + 0.8660254i    2.  - 1.5 - 0.8660254i    0.5 + 4.330127i  
// 
// DFT of Linear Filter o/p Y(k)=   
// 
//    36.  - 15. - 1.7320508i    0    0    0  - 15. + 1.7320508i  
// 
// Linear Convolution result y[n]=   
// 
//    1.    4.    9.    11.    8.    3. 